-- lines.ex
-- show how many lines and characters there are in a 
-- file or bunch of files in the current directory
-- usage: lines.bat [file-spec ...]
-- example: lines *.e *.ex

include wildcard.e
include file.e

constant SCREEN = 1
constant TRUE = 1

function scan(integer fileNum) 
-- count lines, non-blank lines, characters
    object line
    integer lines, nb_lines, chars

    lines = 0
    nb_lines = 0
    chars = 0
    while TRUE do
	line = gets(fileNum)
	if atom(line) then   
	    -- end of file
	    return {nb_lines, lines, chars}
	else
	    lines = lines + 1
	    chars = chars + length(line) + 1  -- \r is hidden
	    if find(TRUE, line != ' ' and line != '\t' and line != '\n') then
		nb_lines = nb_lines + 1
	    end if
	end if
    end while
end function

procedure lines()
-- main procedure 
    integer fileNum
    sequence count, total_count
    sequence file_names, dir_names
    sequence cl, file_spec, name
    
    -- gather eligible file names
    cl = command_line()
    file_spec = {}
    for i = 3 to length(cl) do
	file_spec = append(file_spec, cl[i])
    end for
    if length(file_spec) = 0 then
	file_spec = {"*.*"}
    end if
    dir_names = dir(current_dir())
    file_names = {}
    for f = 1 to length(file_spec) do
	for i = 1 to length(dir_names) do
	    if not find('d', dir_names[i][D_ATTRIBUTES]) then
		name = dir_names[i][D_NAME]
		if wildcard_file(file_spec[f], name) then 
		    if not find(name, file_names) then
			file_names = append(file_names, name)
		    end if
		end if
	    end if
	end for
    end for
    
    -- process all files    
    total_count = {0, 0, 0}
    puts(SCREEN, "non-blank-lines   lines   chars\n")
    for i = 1 to length(file_names) do
	fileNum = open(file_names[i], "r")   
	if fileNum = -1 then
	    printf(SCREEN, "cannot open %s\n", {file_names[i]})
	else
	    count = scan(fileNum)
	    total_count = total_count + count
	    printf(SCREEN, "       %8d%8d%8d %s\n", count & {file_names[i]})
	    close(fileNum)
	end if
    end for
    if length(file_names) > 1 then
	printf(SCREEN, "       %8d%8d%8d total\n", total_count)
    end if
end procedure

lines()

